<?php
session_start();
require_once '../../config/database.php';
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 90000); //300 seconds = 5 minutes

$setExcelName	   = "Order-list";
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');
$currencyFormat = html_entity_decode("0.00",ENT_QUOTES,'UTF-8');	
if (PHP_SAPI == 'cli')
	die('This example should only be run from a Web Browser');
require_once dirname(__FILE__) . '/../Classes/PHPExcel.php';
// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
$currencyFormat = html_entity_decode("0.00",ENT_QUOTES,'UTF-8');			
// Set document properties
$objPHPExcel->getProperties()->setCreator("Maarten Balliauw")
							 ->setLastModifiedBy("Maarten Balliauw")
							 ->setTitle("Office 2007 XLSX Test Document")
							 ->setSubject("Office 2007 XLSX Test Document")
							 ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
							 ->setKeywords("office 2007 openxml php")
							 ->setCategory("Test result file");


// Add some data
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 's.no.')
            ->setCellValue('B1', 'Date')
            ->setCellValue('C1', 'Order Id')
            ->setCellValue('D1', 'Customer Name')
			->setCellValue('E1', 'State')
            ->setCellValue('F1', 'District')
            ->setCellValue('G1', 'Beat')
			->setCellValue('H1', 'Mobile')
			->setCellValue('I1', 'Product Name')
			->setCellValue('J1', 'SKU')
			->setCellValue('K1', 'Unit')
			->setCellValue('L1', 'Price')
			->setCellValue('M1', 'Qty')
			->setCellValue('N1', 'Total')
			->setCellValue('O1', 'Order Total')
			->setCellValue('P1', 'Distributor Name');

			// Miscellaneous glyphs, UTF-8
			$i    = 2;
			$j    = 1;
			$sgst = "";
			$cgst = "";
			$igst = "";
			$sql = mysqli_query($cn,$_SESSION['orderQuery']);
			while($rows  = mysqli_fetch_array($sql))
			{								  
					$sqlEmployee     = mysqli_query($cn,"select * from `tbl_retailer` where `id`='".$rows['shop_id']."'");                                                       							
                    $sqlEmployeeData = mysqli_fetch_array($sqlEmployee);										
					
					$sqlProduct      = mysqli_query($cn,"select * from `tbl_product` where `id`='".$rows['product_id']."'");                                                       							
                    $sqlProductData  = mysqli_fetch_array($sqlProduct);										
					$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A'.$i, $j)
						->setCellValue('B'.$i, date('d-m-Y',strtotime($rows['order_date'])))
						->setCellValue('C'.$i, str_pad($rows['order_id'], 4, "0", STR_PAD_LEFT))
						->setCellValue('D'.$i, $sqlEmployeeData['shop_name'])
						->setCellValue('E'.$i, $rows['state'])
						->setCellValue('F'.$i, $rows['district'])
						->setCellValue('G'.$i, $rows['beat'])
						->setCellValue('H'.$i, $sqlEmployeeData['mobile'])
						->setCellValue('I'.$i, $sqlProductData['product_name'])
						->setCellValue('J'.$i, $rows['sku'])
						->setCellValue('K'.$i, $rows['unit'])
						->setCellValue('L'.$i, $rows['price'])
						->setCellValue('M'.$i, $rows['qty'])
						->setCellValue('N'.$i, $rows['total'])
						->setCellValue('O'.$i, $rows['order_total'])
						->setCellValue('P'.$i, "");
						$i++;
						$j++;
			}	
	

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Simple');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client's web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename='.$setExcelName.".xls");
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;